-- latest update: Game Version 2.1.2.1940

function WoWMap_OnLoad(this)
	this:RegisterEvent("VARIABLES_LOADED")
	this:RegisterEvent( "MAP_CHANGED" )
end

zoneName={}
for i=1, 20000 do
	zoneName[i]="";
end
zoneName={
	--[7]="weeping coast",
	--[8]="savage lands",
	--[9]="mount al turaj",
	--[12]="elven citadel",
	--[115]="dgn_echoes_of_the_sea",
	--[116]="dgn_the_origin",
	--[117]="dgn_hall_of_survivors",
	--[118]="dgn_moonspring_hollow",
	--[208]="dgn_varanas_dreamscape",
	--[252]="tiledgn_citadel_agriza",
	--[352]="eventdgn_goblin_mines",
	}
	

--[[WorldMapFrameIDs:
Zones
1 = Howling Mountains - Heulende Berge
2 = Silverspring - Silberquell
3 = Ravenfell - Rabenfeld
4 = Aslan - Aslan-Tal
5 = Ystra - Ystra-Hochland
6 = Dust Devil Canyon - Staubteufel-Canyon
7 = Weeping Coast - Kte der Wehklagen
8 = Savage Lands - Wilde Lande
9 = Aotulia Vulcano - Aotulia Vulkan
10 = Sascilia Steppes - Sascilia Steppe
11 = Dragonfang Ridge - Drachenzahngebirge
12 = Elven Island - Elfeninsel
Cities&World
9999 = Candara (worldmap) (Yggno Land)
10000 = Varanas - Varanas
10001 = Obsidian Stronghold - Obsidianfeste
Dungeons
100 = Tutorial - Einfrungsgebiet
101 = Cavern of Trials - Hhle der Prungen
102 = Forsaken Abbey - Verlassene Abtei
103 = Necropolis of Mirrors - Grerstadt der Spiegel
104 = Mystic Altar - Mystischer Altar
105 = Queen's Chamber - Kniginnenkammer
106 = Pasper's Shrine - Schrein von Pasper
107 = Shrine of Kalin - Schrein von Kalin
108 = Treasure Trove - Schatzhhle
110 = Barren Caves - Karge Hhlen	
113 = Ruins of the Ice Dwarf Kingdom - Ruinen des Eiszwergknigreiches (40)
114 = Ruins of the Ice Dwarf Kingdom - Ruinen des Eiszwergknigreiches (50)
115 = Ocean's Heart - Herz des Ozeans
116 = Origin - Ursprung
117 = Hall of Survivors - Halle der berlebenden
118 = Moonspring Hollow - Hhle des Wasserdrachen
119 = Lair of the Demon Dragon - Hort des Donendrachen (not there yet)
TileDungeons
201 = Bloody Gallery - Blutige Galerie
202 = Revivers' Corridor - Auferstehungskorridor
203 = Guards' Corridor - Korridor der Whter
204 = Royals' Refuge - Korridor der Zuflucht
205 = Revivers' Corridor - Auferstehungskorridor
206 = Guards' Corridor - Korridor der Whter
207 = Royals' Refuge - Korridor der Zuflucht
208 = Varanas Nightmare - Albtraum von Varanas
250 = Windmill Basement - Windmlenkeller
251 = Arcane Chamber of Sathkur - Arkane Kammer des Sathkur
252 = Cyclops Lair - Hhle der Zyklopen
EventDungeons
301 = Fungus Habitat - Pilzgarten
302 = Wind Wild Animus - Seele der Sturmhhe		
303 = Wedding Hall - Hochzeitssaal  (not there yet)
350 = Windrunner Race - Windlfer-Rennen
351 = Maladina (no functional map in this zone)
352 = Goblin Mines - Goblin-Mine
353 = Maladina 2 (no functional map in this zone)
Battlegrounds
400 = Residence (no functional map in this zone)
401 = Guild Castle - Gildenburg
410 = 1vs1 Arena - 1 gegen 1 Arena
411 = 6vs6 Arena - 6 gegen 6 Arena
430 = 3vs3 Arena - 3 gegen 3 Arena
431 = Kaloshi Canyon (CTF Battleground) - Karros-Schlucht
432 = Visdun Fortress (Tower Defense) - Visdun-Festung
440 = 1vs1 Arena - 1 gegen 1 Arena
441 = Windrunner Race - Windlfer-Rennen
442 = 3vs3 Arena - 3 gegen 3 Arena
443 = 6vs6 Arena - 6 gegen 6 Arena
444 = Kaloshi Canyon (CTF Battleground) - Karros-Schlucht
445 = Visdun Fortress (Tower Defense) - Visdun-Festung
450 = Vermillia Basin (GvG Battleground) (not there yet)

]]
	
	local old_WorldMapFrame_OnClick = WorldMapFrame_OnClick
	local old_WorldMapFrame_OnUpdate = WorldMapFrame_OnUpdate
	local old_WorldMapFrame_OnLeave = WorldMapFrame_OnLeave
    local old_WorldMapFrame_OnShow = WorldMapFrame_OnShow
	local old_WorldMapFrame_OnHide = WorldMapFrame_OnHide
	local loc = GetLanguage():upper()
		if loc == "ENUS" then
			loc = "ENEU";
		end
	local map = nil
	
function WoWMap_OnEvent(_event, _arg1)
    if _event == "VARIABLES_LOADED" then
        if AddonManager then
            local addon = {
                name = "WoWMap",
                version = "v1.8.5",
                author = "DaKhaa, Dusk",
                description = "Makes the map in RoM feel more like the map in WoW for easier handling.",
                icon = "Interface/Addons/WoWMap/highlights/map",
                category = "Map",
                configFrame = nil, 
                slashCommand = nil,
                miniButton = nil,
            }
            if AddonManager.RegisterAddonTable then
                AddonManager.RegisterAddonTable(addon)
            else
                AddonManager.RegisterAddon(addon.name, addon.description, addon.icon, addon.category, 
                    addon.configFrame, addon.slashCommand, addon.miniButton, addon.version, addon.author);
            end
        else
            DEFAULT_CHAT_FRAME:AddMessage("WoWMap v1.8.5 loaded.");
        end
		WoWMap_LoadFile("Interface//AddOns//WoWMap//locales//lang."..loc..".lua");
		--[[map = loadfile("Interface/Addons/WoWMap/maps/"..loc.."/localmaps.lua")
		if map ~= nil then
			DEFAULT_CHAT_FRAME:AddMessage(MAPS_LOADED_LOCAL)
		else
			DEFAULT_CHAT_FRAME:AddMessage(MAPS_LOADED_DEFAULT)
		end]]
	elseif _event == "MAP_CHANGED" then
        ZoneID = GetCurrentWorldMapID()
    end
end
	
		    
    WorldMapFrame_OnShow = function(this)
        old_WorldMapFrame_OnShow(this)
        ZoneID = GetCurrentWorldMapID()
    end

	WorldMapFrame_OnLeave = function(this)
		old_WorldMapFrame_OnLeave(this)
		WoWMapHighlight:Hide()
	end
	
	WorldMapFrame_OnUpdate = function(elapsedTime)
		old_WorldMapFrame_OnUpdate(elapsedTime)
		WoWMap_Update()
	end

	WorldMapFrame_OnHide = function(this)
		old_WorldMapFrame_OnHide(this)
		HideUIPanel(WorldMapFrame)
		HideUIPanel(WoWMapHighlight)
	end
	
	WoWMapZoomOutTable = {
						--Zones
							[1] = 9999,
							[2] = 9999,
							[3] = 9999,
							[4] = 9999,
							[5] = 9999,
							[6] = 9999,
							[7] = 9999,
							[8] = 9999,
							[9] = 9999,
							[10] = 9999,
							[11] = 9999,
							[12] = 9999,
						--Dungeons
							[100] = 1,
							[101] = 1,
							[102] = 2,
							[103] = 4,
							[104] = 5,
							[105] = 6,
							[106] = 10,
							[107] = 6,
							[108] = 3,
							[110] = 1,
							[113] = 11,
							[114] = 11,
							[115] = 7,
							[116] = 4,
							[117] = 8,
							[118] = 1,
							[119] = 9,
						--TileDungeons
							[201] = 2,
							[202] = 5,
							[203] = 5,
							[204] = 5,
							[205] = 5,
							[206] = 5,
							[207] = 5,
							[208] = 10000,
							[250] = 1,
							[251] = 10,
							[252] = 11,
						--EventDungeons
							[301] = 1,
							[302] = 6,
							[303] = 10000,
							[350] = 10000,
							[352] = 4,
						--Battlegrounds
							[401] = 9999,
							[410] = 10001,
							[411] = 10001,
							[430] = 10001,
							[431] = 10001,
							[432] = 10001,
							[440] = 10001,
							[441] = 10000,
							[442] = 10001,
							[443] = 10001,
							[444] = 10001,
							[445] = 10001,
							[450] = 10001,
						--Cities and World
							[9999] = 9999,
							[10000] = 2,
							[10001] = 6,
	}
	--format: ["zonename"] = {x1, y1, x2, y2}
	local WorldMapCoords = {
							["Howling Mountains"] = {0.490805, 0.610706, 0.540611, 0.702488},	-- 1
							["Silverspring"] = {0.520144, 0.380076, 0.590885, 0.530814},		-- 2
							["Ravenfell"] = {0.630000, 0.380000, 0.730000, 0.490000},			-- 3
							["Aslan Valley"] = {0.440170, 0.420437, 0.500177, 0.540388},		-- 4
							["Ystra Highlands"] = {0.310600, 0.540409, 0.420914, 0.680293},		-- 5
							["Dustbloom Canyon"] = {0.320664, 0.320377, 0.400638, 0.470414},	-- 6
							["Weeping Coast"] = {0.650664, 0.170377, 0.790638, 0.340414},		-- 7
							["Savage Lands"] = {0.455004, 0.140077, 0.590038, 0.330014},		-- 8
							--["Aotulia"] = {0.455004, 0.140077, 0.590038, 0.330014},			-- 9 ???
							["AotuliaPreview"] = {0.270493, 0.340321, 0.320385, 0.400384},		-- 9Pre
							["Sascalia Steppes"] = {0.101397, 0.450328, 0.250774, 0.670319},	-- 10
							["Dragonfang"] = {0.100163, 0.700231, 0.340833, 0.820821},			-- 11
							["Elven Citadel"] = {0.840402, 0.460044, 0.900024, 0.550025},		-- 12
							["Varanas"] = {0.543402, 0.805844, 0.723524, 0.925925},				-- 10000
							["Varanas WM"] = {0.555402, 0.545044, 0.600024, 0.600025},			-- 10000
							["Obsidian"] = {0.201605, 0.651041, 0.353515, 0.792840},			-- 10001
							["Obsidian WM"] = {0.280402, 0.470044, 0.320024, 0.510025},			-- 10001
							["Obsidian ST"] = {0.740402, 0.220044, 0.890024, 0.380025},			-- 10001
							["Moongorge"] = {0.640437, 0.345011, 0.710988, 0.405902},			-- 101
							["Abbey"] = {0.35026, 0.600405, 0.402343, 0.694444},				-- 102
							["Necropolis"] = {0.593315, 0.840567, 0.670355, 0.898692},			-- 103
							["Altar"] = {0.490043, 0.765868, 0.57514, 0.846821},				-- 104
							["Queen"] = {0.420062, 0.600405, 0.473231, 0.665361},				-- 105
							["Borsburs"] = {0.115031, 0.29087, 0.182901, 0.369606},				-- 106
							["Kalin"] = {0.406206, 0.3528, 0.462224, 0.435562},					-- 107
							["Treasure Trove"] = {0.330000, 0.740000, 0.40000, 0.820000},		-- 108
							["Barren Caves"] = {0.211458, 0.155231, 0.264965, 0.226377},		-- 110
							["Ice Dwarf"] = {0.815000, 0.750000, 0.880373, 0.835865},			-- 113, 114
							["Oceans Heart"] = {0.730315, 0.580567, 0.800355, 0.660692},		-- 115
							["Origin"] = {0.230493, 0.340321, 0.290385, 0.400384},				-- 116
							["Survivors"] = {0.470315, 0.120567, 0.520355, 0.180692},			-- 117
							["SurvivorsSL"] = {0.593315, 0.880567, 0.655355, 0.958692},			-- 117
							["Moonspring"] = {0.720437, 0.345011, 0.760988, 0.405902},			-- 118
							["Dragons Nest"] = {0.328411, 0.600405, 0.37026, 0.694444},			-- 119
							["Gallery"] = {0.288411, 0.600405, 0.35026, 0.694444},				-- 201
							["Reviver"] = {0.272727, 0.511643, 0.341937, 0.579768},				-- 202, 205
							["Guard"] = {0.193517, 0.511643, 0.257727, 0.579768},				-- 203, 206
							["Royal"] = {0.238122, 0.448518, 0.302332, 0.516643},				-- 204, 207
							["Nightmare"] = {0.270093, 0.310321, 0.305000, 0.375384},			-- 208
							["Windmill"] = {0.498593, 0.446967, 0.558593, 0.497858},			-- 250
							["Sathkur"] = {0.245987, 0.548321, 0.310092, 0.636085},				-- 251
							["Cyclops"] = {0.085652, 0.172642, 0.158373, 0.248865},				-- 252
							["Fungus"] = {0.391493, 0.548321, 0.428385, 0.607384},				-- 301
							["Wind Wild"] = {0.162206, 0.8528, 0.222224, 0.921562},				-- 302
							["Windrunner"] = {0.305493, 0.270321, 0.355385, 0.355384},			-- 350
							["Goblin Mines"] = {0.510062, 0.615005, 0.545001, 0.660061},		-- 352
							["Guild Castle V1"] = {0.480493, 0.190321, 0.540385, 0.280384},		-- 401
							["Guild Castle V2"] = {0.230493, 0.420321, 0.290385, 0.500384},		-- 401
							["Guild Castle O"] = {0.512093, 0.200021, 0.581085, 0.300084},		-- 401
							["1vs1"] = {0.472093, 0.670021, 0.545085, 0.742084},				-- 410
							["6vs6"] = {0.588093, 0.670021, 0.625085, 0.742084},				-- 411
							["3vs3"] = {0.530093, 0.670021, 0.585085, 0.742084},				-- 430
							["Kaloshi"] = {0.472093, 0.750021, 0.545085, 0.802084},				-- 431
							["Visdun"] = {0.530093, 0.750021, 0.585085, 0.802084},				-- 432
							["Vermillia"] = {0.588093, 0.750021, 0.625085, 0.802084},			-- 450
						}

WorldMapFrame_OnClick = function(this, key)
        if IsShiftKeyDown() then
        	old_WorldMapFrame_OnClick(this, key)
        else
        	if key == "RBUTTON" then
        		--DEFAULT_CHAT_FRAME:AddMessage("setting to "..WoWMapZoomOutTable[GetCurrentWorldMapID()])
				if WoWMapZoomOutTable[ZoneID] then
                    ZoneID = WoWMapZoomOutTable[ZoneID]
        		else
        			ZoneID = 9999
        		end
                tWorldMapFrame_SetWorldMapID(ZoneID)
        	elseif key == "LBUTTON" then
			
			--[[for implementing new icons

				local x,y = GetCursorPos()
				local _x,_y = WorldMapFrame:GetPos()
				local _w,_h = WorldMapFrame:GetRealSize()
			
				_y = WorldMapFrame:GetTop()
				_x = WorldMapFrame:GetLeft()
			
				x = ( x - _x ) / _w
				y = ( y - _y ) / _h
				
				DEFAULT_CHAT_FRAME:AddMessage(x.." - "..y)]]
				
				if WoWMapID then
                    ZoneID = WoWMapID
					tWorldMapFrame_SetWorldMapID(ZoneID);
				end
        	end
        end
end

function tWorldMapFrame_SetWorldMapID(id)
	if zoneName[ZoneID] then 
		WorldMapFrame_SetWorldMapID(106);
	else
		WorldMapFrame_SetWorldMapID(id);
	end
end


function SetDungeonMap(ID)
		ctfID = GetZoneID()
		if ctfID == 431 then
			SetWorldMapID(431)

			ZoneID = 431
			ZoneName = GetZoneEnglishName(431)
					
			for i=1, 12 do
				local WorldMapTexture = getglobal( "WorldMapViewFrame_WorldMapTexture_" .. i )
				--[[if map ~= nil then
					WorldMapTexture:SetFile( "\\Interface\\AddOns\\WoWMap\\maps\\"..loc.."\\" .. ZoneName .. "\\" .. i )
				else	
					WorldMapTexture:SetFile( "\\Interface\\WorldMap\\"..loc.."\\" .. ZoneName .. "\\" .. i )
				end]]
				WorldMapTexture:SetFile( "\\Interface\\WorldMap\\"..loc.."\\" .. ZoneName .. "\\" .. i )
			end
		
			ZoneName = GetZoneLocalName(431)
			WorldMapSelectMapButton:SetText( ZoneName )
	
		elseif ID==9999 then
			ZoneName=GetZoneEnglishName(ID);
			tWorldMapFrame_SetWorldMapID(ID);
			for i=1, 12 do
				getglobal( "WorldMapViewFrame_WorldMapTexture_" .. i ):SetFile( "Interface/WorldMap/eneu/" .. ZoneName .. "/" .. i ) 
			end
			WorldMapSelectMapButton:SetText(WoWMap_ZoneLocalName[ID])
		else
			if zoneName[ID] then
				ZoneName=zoneName[ID];
			else
				ZoneName = GetZoneEnglishName(ID);
			end
			tWorldMapFrame_SetWorldMapID(ID);
	
			if not ZoneName then ZoneName=GetZoneEnglishName(9999); end
--			DEFAULT_CHAT_FRAME:AddMessage(ID..ZoneName);
			for i=1, 12 do
				getglobal( "WorldMapViewFrame_WorldMapTexture_" .. i ):SetFile( "Interface/WorldMap/"..loc.."/" .. ZoneName .. "/" .. i )
			end
			WorldMapSelectMapButton:SetText(WoWMap_ZoneLocalName[ID])
		end
end

function WoWMap_Update()
	local file, scale, posX, posY, desc = WoWMap_EvalCursor()
	local width = WorldMapViewFrame:GetWidth()
	local height = WorldMapViewFrame:GetHeight()
	
	if file and file ~= "" then
		WoWMapHighlight:SetTexture("Interface\\AddOns\\WoWMap\\highlights\\"..file..".png")
		WoWMapHighlight:SetScale(scale) 
		WoWMapHighlight:SetWidth((width/921)*128)
		WoWMapHighlight:SetHeight((height/691)*128)
		WoWMapHighlight:ClearAllAnchors() 
		WoWMapHighlight:SetAnchor("TOPLEFT", "TOPLEFT", "WorldMapViewFrame", posX*width, posY*height)
		--DEFAULT_CHAT_FRAME:AddMessage("received "..file.." - "..width.." - "..desc)
		WoWMapHighlight:Show()
		if desc and desc ~= "" then
			WorldMapPlayerPos:SetText( desc )
			WorldMapPlayerPos:Show()
		end
	else
		WoWMapHighlight:Hide()
	end
	if ZoneID == 1 then
		SetDungeonMap(1)
	elseif ZoneID == 2 then
		SetDungeonMap(2)
	elseif ZoneID == 3 then
		SetDungeonMap(3)
	elseif ZoneID == 4 then
		SetDungeonMap(4)
	elseif ZoneID == 5 then
		SetDungeonMap(5)
	elseif ZoneID == 6 then
		SetDungeonMap(6)
	elseif ZoneID == 7 then
		SetDungeonMap(7)
	elseif ZoneID == 8 then
		SetDungeonMap(8)
	elseif ZoneID == 9 then
		SetDungeonMap(9)
	elseif ZoneID == 10 then
		SetDungeonMap(10)
	elseif ZoneID == 11 then
		SetDungeonMap(11)
	elseif ZoneID == 12 then
		SetDungeonMap(12)
	elseif ZoneID == 100 then
		SetDungeonMap(100)
	elseif ZoneID == 101 then
		SetDungeonMap(101)
	elseif ZoneID == 102 then
		SetDungeonMap(102)
	elseif ZoneID == 103 then
		SetDungeonMap(103)
	elseif ZoneID == 104 then
		SetDungeonMap(104)
	elseif ZoneID == 105 then
		SetDungeonMap(105)
	elseif ZoneID == 106 then
		SetDungeonMap(106)
	elseif ZoneID == 107 then
		SetDungeonMap(107)
	elseif ZoneID == 108 then
		SetDungeonMap(108)
	elseif ZoneID == 110 then
		SetDungeonMap(110)
	elseif ZoneID == 113 then
		SetDungeonMap(113)
	elseif ZoneID == 114 then
		SetDungeonMap(114)
	elseif ZoneID == 115 then
		SetDungeonMap(115)
	elseif ZoneID == 116 then
		SetDungeonMap(116)
	elseif ZoneID == 117 then
		SetDungeonMap(117)
	elseif ZoneID == 118 then
		SetDungeonMap(118)
	elseif ZoneID == 119 then
		SetDungeonMap(119)
	elseif ZoneID == 201 then
		SetDungeonMap(201)
	elseif ZoneID == 202 then
		SetDungeonMap(202)
	elseif ZoneID == 203 then
		SetDungeonMap(203)
	elseif ZoneID == 204 then
		SetDungeonMap(204)
	elseif ZoneID == 205 then
		SetDungeonMap(205)
	elseif ZoneID == 206 then
		SetDungeonMap(206)
	elseif ZoneID == 207 then
		SetDungeonMap(207)
	elseif ZoneID == 208 then
		SetDungeonMap(208)
	elseif ZoneID == 250 then
		SetDungeonMap(250)
	elseif ZoneID == 251 then
		SetDungeonMap(251)
	elseif ZoneID == 252 then
		SetDungeonMap(252)
	elseif ZoneID == 301 then
		SetDungeonMap(301)
	elseif ZoneID == 302 then
		SetDungeonMap(302)
	elseif ZoneID == 303 then
		SetDungeonMap(303)
	elseif ZoneID == 350 then
		SetDungeonMap(350)
	elseif ZoneID == 352 then
		SetDungeonMap(352)
	elseif ZoneID == 401 then
		SetDungeonMap(401)
	elseif ZoneID == 410 then
		SetDungeonMap(410)
	elseif ZoneID == 411 then
		SetDungeonMap(411)
	elseif ZoneID == 430 then
		SetDungeonMap(430)
	elseif ZoneID == 431 then
		SetDungeonMap(431)
	elseif ZoneID == 432 then
		SetDungeonMap(432)
	elseif ZoneID == 440 then
		SetDungeonMap(440)
	elseif ZoneID == 441 then
		SetDungeonMap(441)
	elseif ZoneID == 442 then
		SetDungeonMap(442)
	elseif ZoneID == 443 then
		SetDungeonMap(443)
	elseif ZoneID == 444 then
		SetDungeonMap(444)
	elseif ZoneID == 445 then
		SetDungeonMap(445)
	elseif ZoneID == 450 then
		SetDungeonMap(450)
	elseif ZoneID == 9999 then
		SetDungeonMap(9999)
	elseif ZoneID == 10000 then
		SetDungeonMap(10000)
	elseif ZoneID == 10001 then
		SetDungeonMap(10001)
	end
end


function WoWMap_EvalCursor()
	local x,y = GetCursorPos()
	local _x,_y = WorldMapFrame:GetPos()
	local _w,_h = WorldMapFrame:GetRealSize()
	
	local highlight = ""
	local scale = 0
	local posX = 0
	local posY = 0
	local desc = ""
	WoWMapID = nil
			
	_y = WorldMapFrame:GetTop()
	_x = WorldMapFrame:GetLeft()
			
	x = ( x - _x ) / _w
	y = ( y - _y ) / _h
				
	--DEFAULT_CHAT_FRAME:AddMessage(x.." - "..y)
	if ZoneID == 9999 then		
		if x > WorldMapCoords["Howling Mountains"][1] and x < WorldMapCoords["Howling Mountains"][3] and y > WorldMapCoords["Howling Mountains"][2] and y < WorldMapCoords["Howling Mountains"][4] then
			highlight = "howling"
			scale = 0.9
			posX = 0.509174
			posY = 0.605
			desc = WoWMap_ZoneLocalName[1]
			WoWMapID = 1
		elseif x > WorldMapCoords["Silverspring"][1] and x < WorldMapCoords["Silverspring"][3] and y > WorldMapCoords["Silverspring"][2] and y < WorldMapCoords["Silverspring"][4] then
			highlight = "silverspring"
			scale = 1.1
			posX = 0.431454
			posY = 0.338133
			desc = WoWMap_ZoneLocalName[2]
			WoWMapID = 2
		elseif x > WorldMapCoords["Ravenfell"][1] and x < WorldMapCoords["Ravenfell"][3] and y > WorldMapCoords["Ravenfell"][2] and y < WorldMapCoords["Ravenfell"][4] then
			highlight = "ravenfell"
			scale = 1.2
			posX = 0.500000
			posY = 0.290000
			desc = WoWMap_ZoneLocalName[3]
			WoWMapID = 3
		elseif x > WorldMapCoords["Aslan Valley"][1] and x < WorldMapCoords["Aslan Valley"][3] and y > WorldMapCoords["Aslan Valley"][2] and y < WorldMapCoords["Aslan Valley"][4] then
			highlight = "aslan"
			scale = 1.0
			posX = 0.388306
			posY = 0.400133
			desc = WoWMap_ZoneLocalName[4]
			WoWMapID = 4
		elseif x > WorldMapCoords["Ystra Highlands"][1] and x < WorldMapCoords["Ystra Highlands"][3] and y > WorldMapCoords["Ystra Highlands"][2] and y < WorldMapCoords["Ystra Highlands"][4] then
			highlight = "ystra"
			scale = 1.3
			posX = 0.214581
			posY = 0.395784
			desc = WoWMap_ZoneLocalName[5]
			WoWMapID = 5
		elseif x > WorldMapCoords["Dustbloom Canyon"][1] and x < WorldMapCoords["Dustbloom Canyon"][3] and y > WorldMapCoords["Dustbloom Canyon"][2] and y < WorldMapCoords["Dustbloom Canyon"][4] then
			highlight = "dustbloom"
			scale = 1.0
			posX = 0.303887
			posY = 0.301302
			desc = WoWMap_ZoneLocalName[6]
			WoWMapID = 6
		elseif x > WorldMapCoords["Weeping Coast"][1] and x < WorldMapCoords["Weeping Coast"][3] and y > WorldMapCoords["Weeping Coast"][2] and y < WorldMapCoords["Weeping Coast"][4] then
			highlight = "weeping"
			scale = 1.4
			posX = 0.44887
			posY = 0.095302
			desc = WoWMap_ZoneLocalName[7]
			WoWMapID = 7
		elseif x > WorldMapCoords["Savage Lands"][1] and x < WorldMapCoords["Savage Lands"][3] and y > WorldMapCoords["Savage Lands"][2] and y < WorldMapCoords["Savage Lands"][4] then
			highlight = "savage"
			scale = 1.4
			posX = 0.30999
			posY = 0.08530
			desc = WoWMap_ZoneLocalName[8]
			WoWMapID = 8
		--[[elseif x > WorldMapCoords["Aotulia"][1] and x < WorldMapCoords["Aotulia"][3] and y > WorldMapCoords["Aotulia"][2] and y < WorldMapCoords["Aotulia"][4] then
			highlight = "aotulia"
			scale = 1.4
			posX = 0.30999
			posY = 0.08530
			desc = WoWMap_ZoneLocalName[9]
			WoWMapID = 9]]
		elseif x > WorldMapCoords["Sascalia Steppes"][1] and x < WorldMapCoords["Sascalia Steppes"][3] and y > WorldMapCoords["Sascalia Steppes"][2] and y < WorldMapCoords["Sascalia Steppes"][4] then
			highlight = "sascilia"
			scale = 1.6
			posX = 0.040286
			posY = 0.263661
			desc = WoWMap_ZoneLocalName[10]
			WoWMapID = 10
		elseif x > WorldMapCoords["Dragonfang"][1] and x < WorldMapCoords["Dragonfang"][3] and y > WorldMapCoords["Dragonfang"][2] and y < WorldMapCoords["Dragonfang"][4] then
			highlight = "dragonfang"
			scale = 2.0
			posX = 0.035286
			posY = 0.295369
			desc = WoWMap_ZoneLocalName[11]
			WoWMapID = 11
		elseif x > WorldMapCoords["Elven Citadel"][1] and x < WorldMapCoords["Elven Citadel"][3] and y > WorldMapCoords["Elven Citadel"][2] and y < WorldMapCoords["Elven Citadel"][4] then
			highlight = "island"
			scale = 0.5
			posX = 1.679286
			posY = 0.920369
			desc = WoWMap_ZoneLocalName[12]
			WoWMapID = 12
		elseif x > WorldMapCoords["Varanas WM"][1] and x < WorldMapCoords["Varanas WM"][3] and y > WorldMapCoords["Varanas WM"][2] and y < WorldMapCoords["Varanas WM"][4] then
			highlight = "howling"
			scale = 0.5
			posX = 1.078454
			posY = 1.055369
			desc = WoWMap_ZoneLocalName[10000]
			WoWMapID = 10000
		elseif x > WorldMapCoords["Obsidian WM"][1] and x < WorldMapCoords["Obsidian WM"][3] and y > WorldMapCoords["Obsidian WM"][2] and y < WorldMapCoords["Obsidian WM"][4] then
			highlight = "howling"
			scale = 0.5
			posX = 0.535454
			posY = 0.903369
			desc = WoWMap_ZoneLocalName[10001]
			WoWMapID = 10001
		end
	elseif ZoneID == 10000 then
		if x > WorldMapCoords["Guild Castle V1"][1] and x < WorldMapCoords["Guild Castle V1"][3] and y > WorldMapCoords["Guild Castle V1"][2] and y < WorldMapCoords["Guild Castle V1"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 2.534462
			posY = 0.881534
			desc = WoWMap_ZoneLocalName[401]
			WoWMapID = 401
		elseif x > WorldMapCoords["Guild Castle V2"][1] and x < WorldMapCoords["Guild Castle V2"][3] and y > WorldMapCoords["Guild Castle V2"][2] and y < WorldMapCoords["Guild Castle V2"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.194863
			posY = 2.187613
			desc = WoWMap_ZoneLocalName[401]
			WoWMapID = 401
		elseif x > WorldMapCoords["Windrunner"][1] and x < WorldMapCoords["Windrunner"][3] and y > WorldMapCoords["Windrunner"][2] and y < WorldMapCoords["Windrunner"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.564863
			posY = 1.337613
			desc = WoWMap_ZoneLocalName[350]
			WoWMapID = 350
		elseif x > WorldMapCoords["Nightmare"][1] and x < WorldMapCoords["Nightmare"][3] and y > WorldMapCoords["Nightmare"][2] and y < WorldMapCoords["Nightmare"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.394863
			posY = 1.437613
			desc = WoWMap_ZoneLocalName[208]
			WoWMapID = 208
		end
	elseif ZoneID == 10001 then
		if x > WorldMapCoords["Guild Castle O"][1] and x < WorldMapCoords["Guild Castle O"][3] and y > WorldMapCoords["Guild Castle O"][2] and y < WorldMapCoords["Guild Castle O"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 2.684462
			posY = 0.881534
			desc = WoWMap_ZoneLocalName[401]
			WoWMapID = 401
		elseif x > WorldMapCoords["1vs1"][1] and x < WorldMapCoords["1vs1"][3] and y > WorldMapCoords["1vs1"][2] and y < WorldMapCoords["1vs1"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 2.564863
			posY = 3.487613
			desc = WoWMap_ZoneLocalName[410]
			WoWMapID = 410
		elseif x > WorldMapCoords["6vs6"][1] and x < WorldMapCoords["6vs6"][3] and y > WorldMapCoords["6vs6"][2] and y < WorldMapCoords["6vs6"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 2.964863
			posY = 3.487613
			desc = WoWMap_ZoneLocalName[411]
			WoWMapID = 411
		elseif x > WorldMapCoords["3vs3"][1] and x < WorldMapCoords["3vs3"][3] and y > WorldMapCoords["3vs3"][2] and y < WorldMapCoords["3vs3"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 2.764863
			posY = 3.487613
			desc = WoWMap_ZoneLocalName[430]
			WoWMapID = 430
		elseif x > WorldMapCoords["Kaloshi"][1] and x < WorldMapCoords["Kaloshi"][3] and y > WorldMapCoords["Kaloshi"][2] and y < WorldMapCoords["Kaloshi"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 2.564863
			posY = 3.787613
			desc = WoWMap_ZoneLocalName[431]
			WoWMapID = 431
		elseif x > WorldMapCoords["Visdun"][1] and x < WorldMapCoords["Visdun"][3] and y > WorldMapCoords["Visdun"][2] and y < WorldMapCoords["Visdun"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 2.764863
			posY = 3.787613
			desc = WoWMap_ZoneLocalName[432]
			WoWMapID = 432
		elseif x > WorldMapCoords["Vermillia"][1] and x < WorldMapCoords["Vermillia"][3] and y > WorldMapCoords["Vermillia"][2] and y < WorldMapCoords["Vermillia"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 2.964863
			posY = 3.787613
			desc = WoWMap_ZoneLocalName[450]
			WoWMapID = 450
		end
	elseif ZoneID == 1 then
		if x > WorldMapCoords["Fungus"][1] and x < WorldMapCoords["Fungus"][3] and y > WorldMapCoords["Fungus"][2] and y < WorldMapCoords["Fungus"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.954397
			posY = 2.749638
			desc = WoWMap_ZoneLocalName[301]
			WoWMapID = 301
		elseif x > WorldMapCoords["Barren Caves"][1] and x < WorldMapCoords["Barren Caves"][3] and y > WorldMapCoords["Barren Caves"][2] and y < WorldMapCoords["Barren Caves"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.085776
			posY = 0.578871
			desc = WoWMap_ZoneLocalName[110]
			WoWMapID = 110
		elseif x > WorldMapCoords["Windmill"][1] and x < WorldMapCoords["Windmill"][3] and y > WorldMapCoords["Windmill"][2] and y < WorldMapCoords["Windmill"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 2.605863
			posY = 2.206613
			desc = WoWMap_ZoneLocalName[250]
			WoWMapID = 250
		elseif x > WorldMapCoords["Moongorge"][1] and x < WorldMapCoords["Moongorge"][3] and y > WorldMapCoords["Moongorge"][2] and y < WorldMapCoords["Moongorge"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 3.365906
			posY = 1.591895
			desc = WoWMap_ZoneLocalName[101]
			WoWMapID = 101
		elseif x > WorldMapCoords["Moonspring"][1] and x < WorldMapCoords["Moonspring"][3] and y > WorldMapCoords["Moonspring"][2] and y < WorldMapCoords["Moonspring"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 3.665906
			posY = 1.591895
			desc = WoWMap_ZoneLocalName[118]
			WoWMapID = 118
		end
	elseif ZoneID == 2 then
		if x > WorldMapCoords["Varanas"][1] and x < WorldMapCoords["Varanas"][3] and y > WorldMapCoords["Varanas"][2] and y < WorldMapCoords["Varanas"][4] then
			highlight = "howling"
			scale = 1.3
			posX = 0.423452
			posY = 0.564399
			desc = WoWMap_ZoneLocalName[10000]
			WoWMapID = 10000
		elseif x > WorldMapCoords["Abbey"][1] and x < WorldMapCoords["Abbey"][3] and y > WorldMapCoords["Abbey"][2] and y < WorldMapCoords["Abbey"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.802388
			posY = 3.183791
			desc = WoWMap_ZoneLocalName[102]
			WoWMapID = 102
		elseif x > WorldMapCoords["Survivors"][1] and x < WorldMapCoords["Survivors"][3] and y > WorldMapCoords["Survivors"][2] and y < WorldMapCoords["Survivors"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 2.392388
			posY = 0.403791
			desc = WoWMap_ZoneLocalName[117]
			WoWMapID = 117
		elseif x > WorldMapCoords["Gallery"][1] and x < WorldMapCoords["Gallery"][3] and y > WorldMapCoords["Gallery"][2] and y < WorldMapCoords["Gallery"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.585233
			posY = 3.183791
			desc = WoWMap_ZoneLocalName[201]
			WoWMapID = 201
		end
	elseif ZoneID == 3 then
		if x > WorldMapCoords["Treasure Trove"][1] and x < WorldMapCoords["Treasure Trove"][3] and y > WorldMapCoords["Treasure Trove"][2] and y < WorldMapCoords["Treasure Trove"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.744462
			posY = 3.881534
			desc = WoWMap_ZoneLocalName[108]
			WoWMapID = 108
		end
	elseif ZoneID == 4 then
		if x > WorldMapCoords["Necropolis"][1] and x < WorldMapCoords["Necropolis"][3] and y > WorldMapCoords["Necropolis"][2] and y < WorldMapCoords["Necropolis"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 3.094462
			posY = 4.341534
			desc = WoWMap_ZoneLocalName[103]
			WoWMapID = 103
		elseif x > WorldMapCoords["Origin"][1] and x < WorldMapCoords["Origin"][3] and y > WorldMapCoords["Origin"][2] and y < WorldMapCoords["Origin"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.194863
			posY = 1.587613
			desc = WoWMap_ZoneLocalName[116]
			WoWMapID = 116
		elseif x > WorldMapCoords["Goblin Mines"][1] and x < WorldMapCoords["Goblin Mines"][3] and y > WorldMapCoords["Goblin Mines"][2] and y < WorldMapCoords["Goblin Mines"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 2.572551
			posY = 3.089073
			desc = WoWMap_ZoneLocalName[352]
			WoWMapID = 352
		end
	elseif ZoneID == 5 then
		if x > WorldMapCoords["Altar"][1] and x < WorldMapCoords["Altar"][3] and y > WorldMapCoords["Altar"][2] and y < WorldMapCoords["Altar"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 2.551574
			posY = 4.052098
			desc = WoWMap_ZoneLocalName[104]
			WoWMapID = 104
		elseif x > WorldMapCoords["Guard"][1] and x < WorldMapCoords["Guard"][3] and y > WorldMapCoords["Guard"][2] and y < WorldMapCoords["Guard"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.031487
			posY = 2.532561
			desc = WoWMap_ZoneLocalName[203]
			WoWMapID = 203
		elseif x > WorldMapCoords["Reviver"][1] and x < WorldMapCoords["Reviver"][3] and y > WorldMapCoords["Reviver"][2] and y < WorldMapCoords["Reviver"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.465798
			posY = 2.532561
			desc = WoWMap_ZoneLocalName[202]
			WoWMapID = 202
		elseif x > WorldMapCoords["Royal"][1] and x < WorldMapCoords["Royal"][3] and y > WorldMapCoords["Royal"][2] and y < WorldMapCoords["Royal"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.281216
			posY = 2.170767
			desc = WoWMap_ZoneLocalName[204]
			WoWMapID = 204
		end
	elseif ZoneID == 6 then
		if x > WorldMapCoords["Obsidian"][1] and x < WorldMapCoords["Obsidian"][3] and y > WorldMapCoords["Obsidian"][2] and y < WorldMapCoords["Obsidian"][4] then
			highlight = "howling"
			scale = 1.3
			posX = 0.152008
			posY = 0.463096
			desc = WoWMap_ZoneLocalName[10001]
			WoWMapID = 10001
		elseif x > WorldMapCoords["Wind Wild"][1] and x < WorldMapCoords["Wind Wild"][3] and y > WorldMapCoords["Wind Wild"][2] and y < WorldMapCoords["Wind Wild"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 0.854484
			posY = 4.437178
			desc = WoWMap_ZoneLocalName[302]
			WoWMapID = 302
		elseif x > WorldMapCoords["Kalin"][1] and x < WorldMapCoords["Kalin"][3] and y > WorldMapCoords["Kalin"][2] and y < WorldMapCoords["Kalin"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 2.073284
			posY = 1.737178
			desc = WoWMap_ZoneLocalName[107]
			WoWMapID = 107
		elseif x > WorldMapCoords["Queen"][1] and x < WorldMapCoords["Queen"][3] and y > WorldMapCoords["Queen"][2] and y < WorldMapCoords["Queen"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 2.172551
			posY = 3.039073
			desc = WoWMap_ZoneLocalName[105]
			WoWMapID = 105
		end
	elseif ZoneID == 7 then
		if x > WorldMapCoords["Oceans Heart"][1] and x < WorldMapCoords["Oceans Heart"][3] and y > WorldMapCoords["Oceans Heart"][2] and y < WorldMapCoords["Oceans Heart"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 3.809462
			posY = 2.930534
			desc = WoWMap_ZoneLocalName[115]
			WoWMapID = 115
		end
	elseif ZoneID == 8 then
		if x > WorldMapCoords["SurvivorsSL"][1] and x < WorldMapCoords["SurvivorsSL"][3] and y > WorldMapCoords["SurvivorsSL"][2] and y < WorldMapCoords["SurvivorsSL"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 3.094462
			posY = 4.641534
			desc = WoWMap_ZoneLocalName[117]
			WoWMapID = 117
		elseif x > WorldMapCoords["AotuliaPreview"][1] and x < WorldMapCoords["AotuliaPreview"][3] and y > WorldMapCoords["AotuliaPreview"][2] and y < WorldMapCoords["AotuliaPreview"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.404863
			posY = 1.587613
			desc = WoWMap_ZoneLocalName[9]
			WoWMapID = 9
		end
	elseif ZoneID == 9 then
		if x > WorldMapCoords["Dragons Nest"][1] and x < WorldMapCoords["Dragons Nest"][3] and y > WorldMapCoords["Dragons Nest"][2] and y < WorldMapCoords["Dragons Nest"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.685233
			posY = 3.183791
			desc = WoWMap_ZoneLocalName[119]
			WoWMapID = 119
		end
	elseif ZoneID == 10 then
		if x > WorldMapCoords["Sathkur"][1] and x < WorldMapCoords["Sathkur"][3] and y > WorldMapCoords["Sathkur"][2] and y < WorldMapCoords["Sathkur"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 1.292073
			posY = 2.821997
			desc = WoWMap_ZoneLocalName[251]
			WoWMapID = 251
		elseif x > WorldMapCoords["Borsburs"][1] and x < WorldMapCoords["Borsburs"][3] and y > WorldMapCoords["Borsburs"][2] and y < WorldMapCoords["Borsburs"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 0.597176
			posY = 1.374819
			desc = WoWMap_ZoneLocalName[106]
			WoWMapID = 106
		elseif x > WorldMapCoords["Obsidian ST"][1] and x < WorldMapCoords["Obsidian ST"][3] and y > WorldMapCoords["Obsidian ST"][2] and y < WorldMapCoords["Obsidian ST"][4] then
			highlight = "howling"
			scale = 1.3
			posX = 0.570008
			posY = 0.118096
			desc = WoWMap_ZoneLocalName[10001]
			WoWMapID = 10001
		end
	elseif ZoneID == 11 then
		if x > WorldMapCoords["Cyclops"][1] and x < WorldMapCoords["Cyclops"][3] and y > WorldMapCoords["Cyclops"][2] and y < WorldMapCoords["Cyclops"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 0.488599
			posY = 0.723589
			desc = WoWMap_ZoneLocalName[252]
			WoWMapID = 252
		elseif x > WorldMapCoords["Ice Dwarf"][1] and x < WorldMapCoords["Ice Dwarf"][3] and y > WorldMapCoords["Ice Dwarf"][2] and y < WorldMapCoords["Ice Dwarf"][4] then
			highlight = "dgn"
			scale = 0.2
			posX = 4.227176
			posY = 3.954819
			desc = WoWMap_ZoneLocalName[113]
			WoWMapID = 113
		end
	end
	
	return highlight, scale, posX, posY, desc
end	

function WoWMap_LoadFile(filename)
		local func, err = loadfile(filename);
		if (err) then
			return false, err;
		end;
		dofile(filename);
		return true
end